package com.agilex.healthcare.directscheduling.domain;

import com.fasterxml.jackson.annotation.JsonProperty;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "facilityTeamMember", namespace = Namespace.DirectScheduling)
@XmlAccessorType(value = XmlAccessType.NONE)
public class FacilityMemberTeam extends FacilityMember {

	private static final long serialVersionUID = 2371423734242173696L;

	@XmlElement
	private String teamSid;
	@XmlElement
	private String teamName;
	@XmlElement
	private String teamPurpose;
	@XmlElement
	private String providerSid;
	@XmlElement
	private String staffName;
	@XmlElement
	private String providerPosition;
	@XmlElement
	private String providerStandardPosition;
	@XmlElement
	private String possiblePrimary;

	public String getTeamSid() {

		return teamSid;
	}

	public void setTeamSid(String teamSid) {

		this.teamSid = teamSid;
	}

	public String getTeamName() {

		return teamName;
	}

	public void setTeamName(String teamName) {

		this.teamName = teamName;
	}

	public String getTeamPurpose() {

		return teamPurpose;
	}

	public void setTeamPurpose(String teamPurpose) {

		this.teamPurpose = teamPurpose;
	}

	public String getProviderSid() {

		return providerSid;
	}

	public void setProviderSid(String providerSid) {

		this.providerSid = providerSid;
	}

	@JsonProperty @XmlElement
	public String getStaffName() {

		return staffName;
	}

	public void setStaffName(String staffName) {

		this.staffName = staffName;
	}

	public String getProviderPosition() {

		return providerPosition;
	}

	public void setProviderPosition(String providerPosition) {

		this.providerPosition = providerPosition;
	}

	@JsonProperty("title") @XmlElement(name = "title")
	public String getProviderStandardPosition() {

		return providerStandardPosition;
	}

	public void setProviderStandardPosition(String providerStandardPosition) {

		this.providerStandardPosition = providerStandardPosition;
	}

	public String getPossiblePrimary() {

		return possiblePrimary;
	}

	public void setPossiblePrimary(String possiblePrimary) {

		this.possiblePrimary = possiblePrimary;
	}

	public String toString() {

		StringBuffer sb = new StringBuffer();

		sb.append("facilityId=" + super.getFacilityId()).append("\r\n");
		sb.append("teamSid=" + teamSid).append("\r\n");
		sb.append("teamName=" + teamName).append("\r\n");
		sb.append("teamPurpose=" + teamPurpose).append("\r\n");
		sb.append("providerSid=" + providerSid).append("\r\n");
		sb.append("staffName=" + staffName).append("\r\n");
		sb.append("providerPosition=" + providerPosition).append("\r\n");
		sb.append("providerStandardPosition=" + providerStandardPosition)
				.append("\r\n");
		sb.append("possiblePrimary=" + possiblePrimary).append("\r\n");

		return (sb.toString());
	}

}
